﻿Imports System.Windows.Threading

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Public Sub New()
        InitializeComponent()

        Dim tmr As New DispatcherTimer()
        tmr.Interval = TimeSpan.FromSeconds(1)
        AddHandler tmr.Tick, AddressOf OnTimerTick
        tmr.Start()
    End Sub

    Private Sub OnTimerTick(ByVal sender As Object, ByVal args As EventArgs)
        Dim dt = Date.Now

        rotateSecond.Angle = 6 * dt.Second
        rotateMinute.Angle = 6 * dt.Minute + rotateSecond.Angle / 60
        rotateHour.Angle = 30 * (dt.Hour Mod 12) + rotateMinute.Angle / 12
    End Sub

    Private Sub OnContentPanelSizeChanged(ByVal sender As Object, ByVal args As SizeChangedEventArgs)
        Dim scale = Math.Min(args.NewSize.Width, args.NewSize.Height) / 200
        scaleClock.ScaleX = scale
        scaleClock.ScaleY = scale
    End Sub
End Class
